﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
    
    <title>Zestawienie zbiorcze VAT</title>
    <meta name="GENERATOR" Content="Microsoft Visual Studio 7.0">
    <meta name="CODE_LANGUAGE" Content="C#">
    <meta name="vs_defaultClientScript" content="JavaScript">
    <meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
    <script runat="server">
      void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
      }

      void EwidencjaVAT_OnLoad(Object sender, EventArgs args){
        NagEwidencjiVATT.ParamsEx p     = (NagEwidencjiVATT.ParamsEx)DataContext1.Get(typeof(NagEwidencjiVATT.ParamsEx));
        bool rozliczenia = (p is NagRozliczenVATT.Params || p is NagRozliczenVATT.ParamsEx);
        string wg = "";
        //Grid1.DataSource = new ZestawieniaVAT(DataContext1,p.Typ,rozliczenia,p.Zakres).WgStawek;
        Grid1.DataSource = new ZestawieniaVAT(DataContext1,p.Typ, (Row[])DataContext1.Get(typeof(Row[]))).WgStawek;                    
        wg = "stawek VAT";
        
        string tytul = "Zestawienie zbiorcze {0} VAT wg {1}";
        if(!rozliczenia)
          tytul = string.Format(tytul,"ewidencji",wg);
        else
          tytul = string.Format(tytul,"rozliczeń",wg);

        string tytulNaglowka =
							string.Format("{0} | Typ ewidencji: {1}, Za okres: {2} | Definicja: {3}, Podmiot: {4}, Korekty: {5} | Odliczenia: {6}, Rodzaj: {7}, Rodzaj pod.: {8}, Status pod.: {9}",
							tytul, p.Typ, p.Zakres, p.Definicja == null ? "Wszystkie" : p.Definicja.ToString(),
							p.Podmiot == null ? "Wszyscy" : p.Podmiot.ToString(), p.Korekty, p.Odliczenia, p.RodzajZakupu, p.RodzajPodmiotu, p.StatusPodmiotu);

        if (p.Porownanie != TypPorownania.Brak)
            tytulNaglowka =
							string.Format("{0} | Kwota brutto {1} {2:n}",
								tytulNaglowka, CaptionAttribute.EnumToString(p.Porownanie), p.Kwota);

        ReportHeader1.Title = tytulNaglowka;
      }
    </script>
  </HEAD>
  <body>
    <form id="ZestawinieZbiorczeVAT" method="post" runat="server" onload="EwidencjaVAT_OnLoad">
      <ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business"></ea:DataContext><BR>
      <cc1:ReportHeader id="ReportHeader1" runat="server" title="{0} | Za okres: {1}"></cc1:ReportHeader><BR>
      <ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" ShowPrevAgrSum="InFooter" ShowPageSum="True" ShowAgrSum="True" RowTypeName="Soneta.EwidencjaVat.ZestawieniaVAT+Element,Soneta.Ksiega" RowsInRow="3">
        <Columns>
          <ea:GridColumn Align="Center" DataMember="Opis" Total="Info" ID="colOpis" RowSpan="3"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="NP.Netto.Value" Total="Sum" Caption="Netto NP" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="NP.VAT.Value" Total="Sum" Caption="VAT NP" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="NP.Brutto.Value" Total="Sum" Caption="Brutto NP" Format="{0:n}"></ea:GridColumn>          
          <ea:GridColumn Align="Right" DataMember="ZW.Netto.Value" Total="Sum" Caption="Netto Zw." Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="ZW.VAT.Value" Total="Sum" Caption="VAT Zw." Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="ZW.Brutto.Value" Total="Sum" Caption="Brutto Zw." Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op0.Netto.Value" Total="Sum" Caption="Netto 0%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op0.VAT.Value" Total="Sum" Caption="VAT 0%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op0.Brutto.Value" Total="Sum" Caption="Brutto 0%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op3.Netto.Value" Total="Sum" Caption="Netto 3%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op3.VAT.Value" Total="Sum" Caption="VAT 3%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op3.Brutto.Value" Total="Sum" Caption="Brutto 3%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op6.Netto.Value" Total="Sum" Caption="Netto 6%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op6.VAT.Value" Total="Sum" Caption="VAT 6%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op6.Brutto.Value" Total="Sum" Caption="Brutto 6%" Format="{0:n}"></ea:GridColumn>                    
          <ea:GridColumn Align="Right" DataMember="Op7.Netto.Value" Total="Sum" Caption="Netto 7%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op7.VAT.Value" Total="Sum" Caption="VAT 7%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op7.Brutto.Value" Total="Sum" Caption="Brutto 7%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op12.Netto.Value" Total="Sum" Caption="Netto 12%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op12.VAT.Value" Total="Sum" Caption="VAT 12%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op12.Brutto.Value" Total="Sum" Caption="Brutto 12%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op22.Netto.Value" Total="Sum" Caption="Netto 22%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op22.VAT.Value" Total="Sum" Caption="VAT 22%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Op22.Brutto.Value" Total="Sum" Caption="Brutto 22%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Netto.Value" Total="Sum" Caption="Netto" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="VAT.Value" Total="Sum" Caption="VAT" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Brutto.Value" Total="Sum" Caption="Brutto" Format="{0:n}"></ea:GridColumn>
        </Columns>
      </ea:Grid><BR>
      <cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
    </form>
  </body>
</HTML>

